import React from 'react';

import styles from './BackToTopButton.module.scss';
import SelectArrowIcon from '@/svgs/SelectArrowIcon';

export default function BackToTopButton({
  cta, onClick,
}: {
  cta: string; onClick: (x: any) => void,
}) {
  return !!cta?.length && !!onClick && (
    <div className={styles.BackToTopButton}>
      <button type="button" onClick={onClick}>
        {cta}
        <span className={styles.icon}>
          <SelectArrowIcon />
        </span>
      </button>
    </div>
  );
};
