import React from 'react';
import Image from 'next/image';

import { getAbsoluteUploadUrl } from '@/utils/getAbsoluteUploadUrl';
import { FileType } from '@/types';

import styles from './BasicCover.module.scss';

export default function BasicCover({
  cover: { alternativeText, caption, height, url, width },
}: {
  cover: FileType,
}) {
  return !!height && !!url?.length && !!width && (
    <section className={styles.BasicCover}>
      <Image
        src={getAbsoluteUploadUrl(url)}
        alt={alternativeText || caption || ''}
        height={height}
        width={width}
      />
    </section>
  );
};
