'use client';

import React, { useState } from 'react';

import HtmlContent from '@/components/HtmlContent';
import SelectArrowIcon from '@/svgs/SelectArrowIcon';

import styles from './GlossaryItem.module.scss';

export default function GlossaryItem({
  content = '', title = '',
}: {
  content?: string, title?: string,
}) {
  const [show, setShow] = useState<boolean>(false);

  return !!content?.length && !!title?.length && (
    <div className={styles[`GlossaryItem${show ? '--show' : ''}`]}>
      <button className={styles.head} type="button" onClick={() => setShow(!show)}>
        {title}
        <span className={styles.icon}>
          <SelectArrowIcon />
        </span>
      </button>
      <div className={styles['content-wrapper']}>
        <HtmlContent content={content} />
      </div>
    </div>
  );
};
