import React from 'react';

import styles from './HtmlContent.module.scss';
import Markdown from 'react-markdown';

export default function HtmlContent({
  content = '',
  type = '',
}: {
  content?: string;
  type?: '' | 'small';
}) {
  return !!content?.length && (
    <div className={styles[`HtmlContent${type?.length ? `--${type}` : ''}`]}>
      <Markdown>{content}</Markdown>
    </div>
  );
};
