import React from 'react';

import styles from './InputField.module.scss';

export default function InputField({
  type = 'text',
  value = '',
  placeholder = '',
  onChange,
}: {
  value?: string;
  type?: 'email' | 'text';
  placeholder?: string;
  onChange?: (v: string) => void;
}) {  
  return onChange && (
    <input
      className={styles.InputField}
      type={type}
      value={value}
      placeholder={placeholder}
      onChange={(event) => onChange(event?.target?.value || '')}
    />
  );
};
