import React from 'react';
import Link from 'next/link';

import BasicArrowIcon from '@/svgs/BasicArrowIcon';
import { checkUrlByLanguage } from '@/utils/checkUrlByLanguage';
import { Locale } from '@/i18n.config';

import styles from './LinkItem.module.scss';

export default function LinkItem({
  lang, name = '', path, title,
}: {
  lang: Locale; name?: string; path: string; title: string;
}) {
  const href = checkUrlByLanguage(lang, path);

  if (!!path?.length && !!title?.length) {
    return (
      <Link className={styles.LinkItem} href={href}>
        <span className={styles.title}>{title}</span>
        {!!name?.length && (
          <span className={styles.name}>{name}</span>
        )}
        <span className={styles.icon}>
          <BasicArrowIcon />
        </span>
      </Link>
    );
  }

  return null;
};
