import React from 'react';
import Link from 'next/link';

import BasicArrowIcon from '@/svgs/BasicArrowIcon';
import { checkUrlByLanguage } from '@/utils/checkUrlByLanguage';
import { Locale, defaultLocale } from '@/i18n.config';

import styles from './NextRoomLink.module.scss';
import { NextPageType } from '@/types';
import { formatFloor } from '@/utils/formatFloor';

export default function NextRoomLink({
  cta = '', data, lang = defaultLocale,
}: {
  cta?: string; data?: NextPageType; lang: Locale;
}) {
  const floorSlug = formatFloor(data?.floor || 0);
  const path = `/${floorSlug}/${data?.slug}`;
  const href = checkUrlByLanguage(lang, path);

  return (
    <Link className={styles.NextRoomLink} href={href}>
      {data?.title?.length && (
        <span className={styles.title}>{data.title}</span>
      )}
      {!!cta?.length && (
        <span className={styles.cta}>{cta}</span>
      )}
      <span className={styles.icon}><BasicArrowIcon /></span>
      {data?.name?.length && (
        <span className={styles.room}>{data.name}</span>
      )}
    </Link>
  );
};
