import React from 'react';

import StarFilled from '@/svgs/StarFilled';
import StarOutline from '@/svgs/StarOutline';

import styles from './StarRating.module.scss';

export default function StarRating({
  value = 0,
  setValue,
}: {
  value: number;
  setValue: (v: number) => void;
}) {
  return (
    <div className={styles.StarRating}>
      {[1, 2, 3, 4, 5].map((n: number) => (
        <button
          key={n}
          className={styles[`star-button${value >= n ? '--filled' : ''}`]}
          type="button"
          onClick={() => setValue(n)}
        >
          <StarFilled />
          <StarOutline />
        </button>
      ))}
    </div>
  );
};
