import React from 'react';

import styles from './SubmitButton.module.scss';

export default function SubmitButton({
  text = 'Enviar',
  type = 'submit',
  onClick,
}: {
  text?: string;
  type?: 'submit' | 'button';
  onClick?: any;
}) {
  if (type !== 'submit' && !!onClick) {
    return (
      <button className={styles.SubmitButton} type={type} onClick={onClick}>{text}</button>
    );
  }

  return (
    <button className={styles.SubmitButton} type={type}>{text}</button>
  );
};
