import React, { useContext } from 'react';


import SubmenuTemplate from '@/templates/SubmenuTemplate';
import ToggleButton from '@/components/ToggleButton';
import SwitchButton from '@/components/SwitchButton';
import MenuContext from '@/context/MenuContext/MenuContext';
import SettingsContext from '@/context/SettingsContext/SettingsContext';
// import AudioDescriptionIcon from '@/svgs/AudioDescriptionIcon';
import CameraIcon from '@/svgs/CameraIcon';
import DefaultFontSizeIcon from '@/svgs/DefaultFontSizeIcon/DefaultFontSizeIcon';
import HighContrastIcon from '@/svgs/HighContrastIcon';
import LargeFontSizeIcon from '@/svgs/LargeFontSizeIcon';
import { SettingsMenuContentType } from '.';

import styles from './SettingsMenuContent.module.scss';

export default function SettingsMenuContent({ content }: { content?: SettingsMenuContentType }) {
  const {
    camera,
    fontSize,
    highContrast,
    // screenReader,
    handleSetCamera,
    handleSetFontSize,
    handleSetHighContrast,
    // handleSetScreenReader,
  } = useContext(SettingsContext);

  const { handleSetDefault, handleSetMainMenu } = useContext(MenuContext);

  return (
    <SubmenuTemplate
      title={content?.title}
      handleClose={handleSetDefault}
      handleRegress={handleSetMainMenu}
    >
      <div className={styles.SettingsMenuContent}>
        <p>{content?.description}</p>
        <ul className={styles['settings-list']}>
          <li>
            <span className={styles['settings-icon--high-contrast']}><HighContrastIcon /></span>
            {content?.options?.highContrast?.title}
            <span className={styles.tool}>
              <ToggleButton
                selected={highContrast}
                ariaLabel={content?.options?.highContrast?.ariaLabel}
                setSelected={handleSetHighContrast}
              />
            </span>
          </li>
          <li>
            <span className={styles['settings-icon']}><LargeFontSizeIcon /></span>
            {content?.options?.font?.title}
            <span className={styles.tool}>
              <SwitchButton
                options={[
                  {
                    id: 'default',
                    ariaLabel: content?.options?.font?.defaultAriaLabel,
                    icon: <DefaultFontSizeIcon/>,
                  }, {
                    id: 'large',
                    ariaLabel: content?.options?.font?.largeAriaLabel,
                    icon: <LargeFontSizeIcon />,
                  }
                ]}
                selected={fontSize}
                setSelected={handleSetFontSize}
              />
            </span>
          </li>
          {/* <li>
            <span className={styles['settings-icon']}><AudioDescriptionIcon /></span>
            {content?.options?.audioDescription?.title}
            <span className={styles.tool}>
              <ToggleButton
                selected={screenReader}
                ariaLabel={content?.options?.audioDescription?.ariaLabel}
                setSelected={handleSetScreenReader}
              />
            </span>
          </li> */}
          <li>
            <span className={styles['settings-icon']}><CameraIcon /></span>
            {content?.options?.camera?.title}
            <span className={styles.tool}>
              <ToggleButton
                selected={camera}
                ariaLabel={content?.options?.camera?.ariaLabel}
                setSelected={handleSetCamera}
              />
            </span>
          </li>
        </ul>
      </div>
    </SubmenuTemplate>
  );
};
