import React, { useContext } from 'react';

import SubmenuTemplate from '@/templates/SubmenuTemplate';
import MenuContext from '@/context/MenuContext/MenuContext';
import { StartMenuContentType } from '.';

export default function SettingsMenuContent({
  content,
  onRegress,
  onClose,
}: {
  content?: StartMenuContentType;
  onRegress?: () => void;
  onClose?: () => void;
}) {
  const { handleSetDefault, handleSetMainMenu } = useContext(MenuContext);

  return (
    <SubmenuTemplate
      title={content?.title}
      handleClose={handleSetDefault}
      handleRegress={handleSetMainMenu}
    />
  );
};
