'use client';

import { createContext, useState } from 'react';

const MenuContext = createContext({} as any);

type StepType = 'contact' |
  'default' |
  'languages' |
  'main-menu' |
  'rating' |
  'settings' |
  'tutorial' |
  'start';

export function MenuProvider({ children }: { children: React.ReactNode }) {
  const [menuStep, setMenuStep] = useState<StepType>('default');

  const handleSetContact = () => setMenuStep('contact');

  const handleSetDefault = () => setMenuStep('default');
  
  const handleSetLanguages = () => setMenuStep('languages');

  const handleSetMainMenu = () => setMenuStep('main-menu');

  const handleSetMenuStep = (value: StepType) => setMenuStep(value);

  const handleSetRating = () => setMenuStep('rating');

  const handleSetSettings = () => setMenuStep('settings');

  const handleSetStart = () => setMenuStep('start');

  const handleSetTutorial = () => setMenuStep('tutorial');

  return (
    <MenuContext.Provider
      value={{
        menuStep,
        handleSetContact,
        handleSetDefault,
        handleSetLanguages,
        handleSetMainMenu,
        handleSetMenuStep,
        handleSetRating,
        handleSetSettings,
        handleSetStart,
        handleSetTutorial,
      }}
    >
      {children}
    </MenuContext.Provider>
  );
};

export default MenuContext;
