import React, { ReactNode } from 'react';

import ArrowBackIcon from '@/svgs/ArrowBackIcon';
import CloseButtonIcon from '@/svgs/CloseButtonIcon';

import styles from './BasicHeader.module.scss';

export default function BasicHeader({
  children,
  onClose,
  onRegress,
}: {
  children?: ReactNode;
  onClose?: () => void,
  onRegress?: () => void,
}) {
  return (
    <header className={styles.BasicHeader}>
      <div className={styles.container}>
        {!!onRegress && (
            <button className={styles.back} type="button" onClick={onRegress}>
              <ArrowBackIcon />
            </button>
          )}
          {children}
          {!!onClose && (
            <button className={styles.close} type="button" onClick={onClose}>
              <CloseButtonIcon />
            </button>
          )}
      </div>
    </header>
  );
};
