import React, { useContext } from 'react';

import InputField from '@/components/InputField';
import SelectField from '@/components/SelectField';
import SubmitButton from '@/components/SubmitButton';
import TextareaField from '@/components/TextareaField';
import MessageContext from '@/context/MessageContext/MessageContext';

import styles from './ContactForm.module.scss';

export default function ContactForm({
  description = '',
  emailPlaceholder = 'E-mail',
  messagePlaceholder = 'Mensagem',
  namePlaceholder = 'Nome',
  submit = 'Enviar',
  topicPlaceholder = 'Tópico',
  topicOptions = [],
}: {
  description?: string
  emailPlaceholder?: string;
  messagePlaceholder?: string;
  namePlaceholder?: string;
  submit?: string;
  topicPlaceholder?: string;
  topicOptions?: { value: string; name: string }[];
}) {
  const {
    email,
    fullName,
    message,
    topic,
    handleSetEmail,
    handleSetFullName,
    handleSetMessage,
    handleSetTopic,
    handleSubmitRating,
  } = useContext(MessageContext);

  return (
    <form className={styles.ContactForm} onSubmit={handleSubmitRating}>
      {!!description && (<p>{description}</p>)}
      <ol>
        <li>
          <InputField
            type="text"
            value={fullName}
            placeholder={namePlaceholder}
            onChange={handleSetFullName}
          />
        </li>
        <li>
          <InputField
            type="email"
            value={email}
            placeholder={emailPlaceholder}
            onChange={handleSetEmail}
          />
        </li>
        <li>
          <SelectField
            value={topic}
            options={topicOptions}
            placeholder={topicPlaceholder}
            onChange={handleSetTopic}
          />
        </li>
        <li>
          <TextareaField
            value={message}
            placeholder={messagePlaceholder}
            onChange={handleSetMessage}
          />
        </li>
        <li>
          <SubmitButton text={submit} onClick={handleSubmitRating} />
        </li>
      </ol>
    </form>
  );
};
