'use client';

import React from 'react';
import { useRouter } from 'next/navigation';

import BasicHeader from '@/sections/BasicHeader';
import SelectArrowIcon from '@/svgs/SelectArrowIcon';
import { FloorKeyType } from '@/types';
import { FLOOR_1, GROUND_FLOOR } from '@/constants';
import { Locale, defaultLocale, i18n } from '@/i18n.config';

import styles from './MapPageHeader.module.scss';

export default function MapPageHeader({
  floor = GROUND_FLOOR, lang = i18n.defaultLocale, options = [],
}: {
  floor?: FloorKeyType; lang?: Locale; options?: { value: string; name: string }[];
}) {
  const router = useRouter();

  const onChangeSelect = (v: string) => {
    const href = v === GROUND_FLOOR
      ? `${lang === defaultLocale ? '' : `/${lang}`}/mapa` : `${lang === defaultLocale ? ''
      : `/${lang}`}/mapa/${FLOOR_1}`;

    router.push(href);
  }

  return (
    <BasicHeader
      onClose={() => router.push(lang === 'pt' ? '/' : `/${lang}`)}
      onRegress={() => router.back()}
    >
      <div className={styles.MapPageHeader}>
        <select defaultValue={floor} onChange={({ target }) => onChangeSelect(target?.value)}>
          {options.map((opt) => (<option key={opt.value} value={opt.value}>{opt.name}</option>))}
        </select>
        <SelectArrowIcon />
      </div>
    </BasicHeader>
  );
};
