import React from 'react';

interface Props {
  fill?: string,
  title?: string,
};


export default function CameraIcon({
  fill = '#000000',
  title = 'Icone de câmera fotografica',
}: Props) {
  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" strokeWidth="0" fill={fill}>
      <title>{title}</title>
      <path d="M16.5688,4.8153h-1.2012l-.3003-.9384c-.1947-.5506-.5558-1.0271-1.0333-1.3634-.4775-.3363-1.0478-.5157-1.6318-.5135h-4.8047c-.5898.0011-1.1643.1874-1.6424.5326-.4782.3452-.8359.8318-1.0227,1.3912l-.3003.9384h-1.2012c-.7466,0-1.4627.2966-1.9907.8246-.528.528-.8246,1.244-.8246,1.9907v7.5074c0,.7466.2966,1.4627.8246,1.9906.528.528,1.244.8246,1.9907.8246h13.1379c.7466,0,1.4627-.2966,1.9906-.8246.528-.5279.8246-1.244.8246-1.9906v-7.5074c.0062-.3736-.062-.7448-.2007-1.0918-.1387-.347-.345-.6629-.6071-.9293-.262-.2664-.5745-.478-.9191-.6224-.3447-.1444-.7147-.2188-1.0883-.2187ZM17.5072,15.1378c0,.2489-.0989.4876-.2749.6636-.176.176-.4147.2748-.6635.2748H3.4309c-.2489,0-.4876-.0988-.6636-.2748-.176-.176-.2749-.4147-.2749-.6636v-7.5073c0-.2489.0989-.4876.2749-.6636.176-.176.4147-.2748.6636-.2748h1.8768c.2046.0107.4071-.0459.5766-.1611.1694-.1152.2965-.2828.3618-.477l.5068-1.539c.063-.1864.1829-.3483.3429-.4628.16-.1145.3519-.1759.5486-.1753h4.8047c.1967-.0005.3887.0608.5486.1753.16.1145.28.2764.3429.4628l.5068,1.539c.0602.179.173.3357.3237.4495.1507.1138.3322.1796.5208.1886h1.8769c.2488,0,.4875.0989.6635.2748.176.176.2749.4147.2749.6636v7.5073ZM9.9998,6.6921c-.7424,0-1.4681.2201-2.0854.6326-.6173.4125-1.0984.9987-1.3825,1.6846-.2841.6859-.3584,1.4406-.2136,2.1688.1448.7281.5023,1.3969,1.0273,1.9219.525.525,1.1938.8825,1.9219,1.0273s1.4829.0705,2.1687-.2136c.6859-.2841,1.2721-.7652,1.6846-1.3825.4125-.6173.6326-1.343.6326-2.0854,0-.9955-.3955-1.9503-1.0994-2.6542-.704-.7039-1.6587-1.0994-2.6543-1.0994ZM9.9998,12.3226c-.3712,0-.7341-.1101-1.0427-.3163-.3086-.2062-.5492-.4994-.6913-.8423-.1421-.3429-.1792-.7203-.1068-1.0844.0724-.3641.2512-.6985.5136-.961.2625-.2625.5969-.4412.961-.5136s.7414-.0353,1.0844.1068c.3429.1421.6361.3826.8423.6913.2062.3086.3163.6715.3163,1.0427,0,.4978-.1978.9751-.5497,1.3271-.352.352-.8294.5497-1.3272.5497Z" />
    </svg>
  );
};
