import React from 'react';

export default function FacebookIcon({
  title = 'Icone do Facebook', fill = '#c8d3a7', stroke = '#231f20',
}: {
  fill?: string; stroke?: string; title?: string;
}) {
  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36" strokeWidth="0">
      <title>{title}</title>
      <circle cx="18" cy="18" r="12.5" fill={fill}/>
      <path
        d="M6,18c.0002-2.3093.6668-4.5695,1.9197-6.5094,1.2529-1.9399,3.0389-3.4771,5.1438-4.4271,2.1049-.95,4.4392-1.2725,6.7228-.9287,2.2835.3438,4.4195,1.3391,6.1514,2.8667,1.7319,1.5275,2.9863,3.5224,3.6126,5.7452.6263,2.2227.5979,4.579-.0818,6.7861-.6796,2.207-1.9816,4.1711-3.7498,5.6565-1.7682,1.4854-3.9275,2.429-6.2187,2.7177v-8.907h3c.3978,0,.7794-.158,1.0607-.4393s.4393-.6629.4393-1.0607-.158-.7794-.4393-1.0607-.6629-.4393-1.0607-.4393h-3v-3c0-.3978.158-.7794.4393-1.0607.2813-.2813.6629-.4393,1.0607-.4393h.75c.3978,0,.7794-.158,1.0607-.4393.2813-.2813.4393-.6629.4393-1.0607s-.158-.7794-.4393-1.0607c-.2813-.2813-.6629-.4393-1.0607-.4393h-.75c-1.1935,0-2.3381.4741-3.182,1.318-.8439.8439-1.318,1.9885-1.318,3.182v3h-3c-.3978,0-.7794.158-1.0607.4393-.2813.2813-.4393.6629-.4393,1.0607s.158.7794.4393,1.0607c.2813.2813.6629.4393,1.0607.4393h3v8.907c-2.9-.3657-5.5668-1.7771-7.5-3.9694-1.9332-2.1923-2.9999-5.0147-3-7.9376ZM18,33c8.2845,0,15-6.7155,15-15S26.2845,3,18,3,3,9.7155,3,18s6.7155,15,15,15Z"
        fill={stroke}
      />
    </svg>
  );
};
