import React from 'react';

export default function InstagramIcon({
  title = 'Icone do Instagram', fill = '#c8d3a7', stroke = '#231f20',
}: {
  fill?: string; stroke?: string; title?: string;
}) {
  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36" strokeWidth="0">
      <title>{title}</title>
      <rect x="5" y="5" width="26" height="26" rx="7" ry="7" fill={fill} />
      <path
        d="M11.7,3h12.6c4.8,0,8.7,3.9,8.7,8.7v12.6c0,2.3074-.9166,4.5203-2.5482,6.1518-1.6315,1.6316-3.8444,2.5482-6.1518,2.5482h-12.6c-4.8,0-8.7-3.9-8.7-8.7v-12.6c0-2.3074.9166-4.5203,2.5482-6.1518,1.6316-1.6316,3.8444-2.5482,6.1518-2.5482ZM11.4,6c-1.4322,0-2.8057.5689-3.8184,1.5816-1.0127,1.0127-1.5816,2.3862-1.5816,3.8184v13.2c0,2.985,2.415,5.4,5.4,5.4h13.2c1.4322,0,2.8057-.5689,3.8184-1.5816,1.0127-1.0127,1.5816-2.3862,1.5816-3.8184v-13.2c0-2.985-2.415-5.4-5.4-5.4h-13.2ZM25.875,8.25c.4973,0,.9742.1975,1.3258.5492.3517.3516.5492.8286.5492,1.3258s-.1975.9742-.5492,1.3258c-.3516.3517-.8285.5492-1.3258.5492s-.9742-.1975-1.3258-.5492c-.3517-.3516-.5492-.8285-.5492-1.3258s.1975-.9742.5492-1.3258c.3516-.3516.8285-.5492,1.3258-.5492ZM18,10.5c1.9891,0,3.8968.7902,5.3033,2.1967,1.4065,1.4065,2.1967,3.3142,2.1967,5.3033s-.7902,3.8968-2.1967,5.3033c-1.4065,1.4065-3.3142,2.1967-5.3033,2.1967s-3.8968-.7902-5.3033-2.1967c-1.4065-1.4065-2.1967-3.3142-2.1967-5.3033s.7902-3.8968,2.1967-5.3033,3.3142-2.1967,5.3033-2.1967ZM18,13.5c-1.1935,0-2.3381.4741-3.182,1.318s-1.318,1.9885-1.318,3.182.4741,2.3381,1.318,3.182c.8439.8439,1.9885,1.318,3.182,1.318s2.3381-.4741,3.182-1.318c.8439-.8439,1.318-1.9885,1.318-3.182s-.4741-2.3381-1.318-3.182c-.8439-.8439-1.9885-1.318-3.182-1.318Z"
        fill={stroke}
      />
    </svg>
  );
};
