import React from 'react';

interface Props {
  fill?: string,
  title?: string,
};


export default function PinIcon({
  fill = '#000000',
  title = 'Icone de marcação em mapas',
}: Props) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 20 20"
      fill={fill}
      strokeWidth={0}
    >
      <title>{title}</title>
      <path d="M13.1541,13.1304l2.2668-4.1053c.3027-.6064.5791-1.7192.5781-2.3682-.1426-3.2754-2.8311-5.8413-6.0884-5.8413h-.0015c-1.499-.0645-2.9429.4658-4.0767,1.5024-1.1909,1.0898-1.8862,2.5864-1.9575,4.2466,0,.8662.2759,1.8662.7202,2.6167l2.4048,3.9045c-1.9944.4495-3.375,1.5812-3.375,2.8538,0,1.8525,2.7407,3.25,6.375,3.25s6.375-1.3975,6.375-3.25c0-1.2311-1.2175-2.2705-3.2209-2.8093ZM5.8931,8.4289c-.3101-.5166-.5181-1.2656-.5186-1.8315.0532-1.2271.5757-2.3535,1.4707-3.1729.7896-.7222,1.7808-1.1143,2.8374-1.1143.064,0,.1279.0015.1924.0044,2.4863,0,4.5186,1.936,4.625,4.375,0,.3848-.2246,1.2715-.4082,1.6401l-3.5732,6.5308-.2446.2441c-.0532.0244-.1157.0146-.1528.0068-.0991-.0234-.1768-.0859-.2329-.1904l-3.6392-5.8975-.356-.5947ZM10,17.6896c-2.9307,0-4.875-1.0537-4.875-1.75,0-.3918.9373-1.2273,2.7187-1.4841l.7354,1.194c.2266.4541.6743.7979,1.1973.9219.1387.0322.2783.0488.416.0488.3657,0,.7188-.1143,1.0078-.3311l.4551-.4443.7466-1.3522c1.6947.3756,2.4731,1.0564,2.4731,1.447,0,.6963-1.9443,1.75-4.875,1.75ZM10,8.6896c-1.3784,0-2.5-1.1216-2.5-2.5s1.1216-2.5,2.5-2.5,2.5,1.1216,2.5,2.5-1.1211,2.5-2.5,2.5ZM10,5.1896c-.5513,0-1,.4487-1,1s.4487,1,1,1,1-.4487,1-1-.4487-1-1-1Z" />
    </svg>
  );
};
