import React from 'react';

export default function TooltipTriangleIcon({
  fill = '#344318', stroke = '#242E19', title = 'Apontador de balão',
}: {
  fill?: string; stroke?: string; title?: string;
}) {
  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 16">
      <title>{title}</title>
      <polygon points="24 1 23 1 12 14 1 1 0 1 0 0 24 0 24 1" fill={fill} strokeWidth={0} />
      <polyline
        points="24 1 23 1 12 14 1 1 0 1"
        fill="none"
        stroke={stroke}
        strokeMiterlimit={10}
        stroke-width={2}
      />
    </svg>
  );
};
