import React from 'react';

export default function YouTubeIcon({
  title = 'Icone do YouTube', fill = '#c8d3a7', stroke = '#231f20',
}: {
  fill?: string; stroke?: string; title?: string;
}) {
  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36" strokeWidth="0">
      <title>{title}</title>
      <rect x="6" y="9" width="24" height="18" rx="3" ry="3" fill={fill} />
      <path
        d="M18,6c1.2825,0,2.598.033,3.873.087l1.506.072,1.4415.0855,1.35.0915,1.233.096c1.3381.1024,2.5972.6734,3.5558,1.6126.9586.9391,1.5553,2.1862,1.6852,3.5219l.06.6375.1125,1.365c.105,1.4145.183,2.9565.183,4.431s-.078,3.0165-.183,4.431l-.1125,1.365c-.0195.219-.039.4305-.06.6375-.1299,1.3359-.7269,2.5832-1.6858,3.5224s-2.2184,1.51-3.5567,1.6121l-1.23.0945-1.35.093-1.443.0855-1.506.072c-1.2903.0561-2.5815.0851-3.873.087-1.2915-.0019-2.5827-.0309-3.873-.087l-1.506-.072-1.4415-.0855-1.35-.093-1.233-.0945c-1.3381-.1024-2.5972-.6734-3.5558-1.6126-.9586-.9391-1.5554-2.1862-1.6852-3.5219l-.06-.6375-.1125-1.365c-.1147-1.4743-.1757-2.9523-.183-4.431,0-1.4745.078-3.0165.183-4.431l.1125-1.365c.0195-.219.039-.4305.06-.6375.1298-1.3355.7263-2.5824,1.6846-3.5215.9583-.9391,2.2171-1.5103,3.5549-1.613l1.2315-.096,1.35-.0915,1.443-.0855,1.506-.072c1.2908-.056,2.5825-.0851,3.8745-.087ZM18,9c-1.2375,0-2.511.033-3.75.084l-1.467.0705-1.4085.0825-1.323.09-1.212.0945c-.637.0452-1.2374.3145-1.6949.7601-.4574.4456-.7423,1.0388-.8041,1.6744-.1755,1.8135-.3405,4.071-.3405,6.144s.165,4.3305.3405,6.144c.1275,1.308,1.1655,2.325,2.499,2.4345l1.212.093,1.323.09,1.4085.084,1.467.0705c1.239.051,2.5125.084,3.75.084s2.511-.033,3.75-.084l1.467-.0705,1.4085-.0825,1.323-.09,1.212-.0945c.637-.0452,1.2374-.3145,1.6949-.7601.4574-.4456.7423-1.0388.8041-1.6744.1755-1.8135.3405-4.071.3405-6.144s-.165-4.3305-.3405-6.144c-.0618-.6356-.3467-1.2288-.8041-1.6744-.4575-.4456-1.0579-.7149-1.6949-.7601l-1.212-.093-1.323-.09-1.4085-.084-1.467-.0705c-1.2493-.0538-2.4996-.0818-3.75-.084ZM15,14.3625c-.0001-.1466.0356-.291.104-.4207.0685-.1296.1675-.2406.2886-.3232.1211-.0827.2606-.1345.4062-.151.1457-.0165.2932.0029.4297.0564l.1215.06,6.3,3.636c.1255.0724.2316.174.3094.2962.0778.1221.1249.2613.1374.4056.0126.1443-.0099.2895-.0655.4232-.0556.1337-.1427.2521-.2538.345l-.1275.09-6.3,3.6375c-.127.0735-.27.1149-.4166.1205s-.2923-.0247-.4245-.0883c-.1322-.0636-.2469-.1585-.334-.2766-.0871-.118-.1441-.2555-.1659-.4006l-.009-.135v-7.275Z"
        fill={stroke}
      />
    </svg>
  );
};
