import React, { ReactNode } from 'react';

import BasicHeader from '@/sections/BasicHeader';

import styles from './SubmenuTemplate.module.scss';

export default function SubmenuTemplate({
  title = '',
  children,
  handleRegress,
  handleClose,
}: {
  title?: string;
  children?: ReactNode;
  handleRegress?: () => void;
  handleClose?: () => void;
}) {
  return (
    <section className={styles.SubmenuTemplate}>
      <BasicHeader onRegress={handleRegress} onClose={handleClose}>
        <h3>{title}</h3>
      </BasicHeader>
      {children && (
        <div className={styles.content}>{children}</div>
      )}
    </section>
  );
};
